# Visitor Gate Pass (PHP)

A lightweight PHP + MySQL visitor management system with roles (Admin/Receptionist), visitor check-in/out, expected/returning visitors, email notifications (host & visitor), overstay alerts (email + dashboard), hosts/departments (manual + CSV upload), and branding settings.

## 1) Requirements
- PHP 8+
- MySQL 5.7+ / MariaDB
- Composer (for PHPMailer)
- Cron (optional, for background overstay checks)

## 2) Install
1. Create database and tables:
   ```sql
   SOURCE setup.sql;
   ```
2. Update DB creds in `config/db.php` if needed.
3. Install dependencies:
   ```bash
   composer install
   ```
4. Ensure writable uploads:
   ```bash
   chmod -R 755 assets/uploads
   ```
5. Point your web server's docroot to this folder and open `/auth/login.php`.

### Default Admin
- **Username:** `admin`
- **Password:** `admin123`

## 3) Configure
Go to **Admin → Settings** and set:
- SMTP Host/Port/User/Pass
- Sender Name/Email
- Overstay Hours + Recipients
- Company Name/Slogan/About
- Logo and UI Banner

## 4) Overstay Background Job (Cron)
Run every 15 minutes:
```bash
*/15 * * * * /usr/bin/php /path/to/visitor_gate_pass/cron/check_overstays.php >> /var/log/visitor_overstay.log 2>&1
```

## 5) CSV Format (Hosts)
```
name,email,department
Jane Doe,jane@company.com,HR
John Smith,john@company.com,IT
```

## 6) Security Notes
- Change default admin password after first login.
- Use HTTPS and secure SMTP credentials.
- Consider adding CSRF tokens and stronger password hashing (e.g., password_hash) for production.

## 7) Support
If you need help deploying on shared hosting, Nginx/Apache vhost examples, or adding more roles/fields, reach out in chat.
