<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/app/license.php';

if (!license_is_valid()) {
    header('Location: license-activate.php');
    exit;
}

function fetch_scalar($conn, $sql){
  $res = $conn->query($sql);
  if(!$res){ return 0; }
  $row = $res->fetch_row();
  return (int)($row[0] ?? 0);
}

$total_visitors   = fetch_scalar($conn, "SELECT COUNT(*) FROM visitors");
$total_checked_in = fetch_scalar($conn, "SELECT COUNT(*) FROM visitors WHERE status IN ('checked_in','returning')");
$total_expected   = fetch_scalar($conn, "SELECT COUNT(*) FROM visitors WHERE status='expected'");
$total_inducted   = fetch_scalar($conn, "SELECT COUNT(*) FROM induction");

$today_visitors   = fetch_scalar($conn, "SELECT COUNT(*) FROM visitors WHERE DATE(checkin_time)=CURDATE()");
$today_checked_in = fetch_scalar($conn, "SELECT COUNT(*) FROM visitors WHERE DATE(checkin_time)=CURDATE() AND status IN ('checked_in','returning')");
$today_expected   = fetch_scalar($conn, "SELECT COUNT(*) FROM visitors WHERE DATE(checkin_time)=CURDATE() AND status='expected'");
$today_inducted   = fetch_scalar($conn, "SELECT COUNT(*) FROM induction WHERE DATE(induction_date)=CURDATE()");
?>

<h3 class="mb-3">Dashboard</h3>

<div class="row g-3">
  <div class="col-12"><h6 class="text-muted">Overall</h6></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Total Visitors</div><div class="h4 mb-0"><?php echo $total_visitors; ?></div></div>
    <i class="bi bi-people h2 mb-0 text-primary"></i></div></div></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Currently Checked-in</div><div class="h4 mb-0"><?php echo $total_checked_in; ?></div></div>
    <i class="bi bi-box-arrow-in-right h2 mb-0 text-success"></i></div></div></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Expected Visitors</div><div class="h4 mb-0"><?php echo $total_expected; ?></div></div>
    <i class="bi bi-calendar-check h2 mb-0 text-info"></i></div></div></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Total Inducted</div><div class="h4 mb-0"><?php echo $total_inducted; ?></div></div>
    <i class="bi bi-shield-check h2 mb-0 text-warning"></i></div></div></div>

  <div class="col-12 mt-2"><h6 class="text-muted">Today</h6></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Visitors Today</div><div class="h4 mb-0"><?php echo $today_visitors; ?></div></div>
    <i class="bi bi-graph-up h2 mb-0 text-primary"></i></div></div></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Checked-in Today</div><div class="h4 mb-0"><?php echo $today_checked_in; ?></div></div>
    <i class="bi bi-box-arrow-in-right h2 mb-0 text-success"></i></div></div></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Expected Today</div><div class="h4 mb-0"><?php echo $today_expected; ?></div></div>
    <i class="bi bi-calendar-event h2 mb-0 text-info"></i></div></div></div>
  <div class="col-md-3"><div class="card p-3"><div class="d-flex justify-content-between align-items-center">
    <div><div class="text-muted small">Inducted Today</div><div class="h4 mb-0"><?php echo $today_inducted; ?></div></div>
    <i class="bi bi-patch-check h2 mb-0 text-warning"></i></div></div></div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>