<?php
// ===========================================================
// IMPORT OLD VISITORS FROM EXCEL (FINAL VERSION)
// Save as: /admin/import_old_visitors.php
// ===========================================================

require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';

// Load PhpSpreadsheet
require_once __DIR__ . '/../vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

$msg = "";
$error = "";

// Load departments + employees for mapping
$departments = [];
$res = $conn->query("SELECT id, name FROM departments");
while ($d = $res->fetch_assoc()) {
    $departments[strtoupper(trim($d['name']))] = $d['id'];
}

$hosts = [];
$res2 = $conn->query("SELECT id, name FROM employees");
while ($h = $res2->fetch_assoc()) {
    $hosts[strtoupper(trim($h['name']))] = $h['id'];
}

// ===============================================
// Handle File Upload
// ===============================================

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['excel_file'])) {

    if ($_FILES['excel_file']['error'] !== UPLOAD_ERR_OK) {
        $error = "Upload failed.";
    } else {

        $filePath = $_FILES['excel_file']['tmp_name'];

        try {
            $spreadsheet = IOFactory::load($filePath);
            $sheet = $spreadsheet->getActiveSheet();
            $rows = $sheet->toArray(null, true, true, true);

            $imported = 0;
            $skipped  = 0;

            // Skip header → start from row 2
            for ($i = 2; $i <= count($rows); $i++) {

                $r = $rows[$i];

                $name       = trim($r['A']);
                $in_date    = trim($r['B']);
                $in_time    = trim($r['C']);
                $host_name  = strtoupper(trim($r['D']));
                $dept_name  = strtoupper(trim($r['E']));
                $items      = trim($r['F']);
                $tag        = trim($r['G']);
                $out_date   = trim($r['H']);
                $out_time   = trim($r['I']);

                if ($name == "" || $in_date == "") {
                    $skipped++;
                    continue;
                }

                // Convert MM/DD/YYYY → YYYY-MM-DD
                $checkin_date = date("Y-m-d", strtotime($in_date));
                $checkout_date = $out_date ? date("Y-m-d", strtotime($out_date)) : null;

                // Map host and department
                $host_id = $hosts[$host_name] ?? null;
                $dept_id = $departments[$dept_name] ?? null;

                // Prevent duplicates
                $dup = $conn->prepare("
                    SELECT id FROM visitors
                    WHERE name=? AND checkin_date=? AND checkin_time=?
                    LIMIT 1
                ");
                $dup->bind_param("sss", $name, $checkin_date, $in_time);
                $dup->execute();
                if ($dup->get_result()->num_rows > 0) {
                    $skipped++;
                    continue;
                }

                // Insert record
                $stmt = $conn->prepare("
                    INSERT INTO visitors
                    (name, phone, email, company, gender, address,
                     purpose, host_id, department_id,
                     checkin_date, checkin_time,
                     checkout_time, tag_number, items_declared, status)
                    VALUES (?,?,?,?,?,?,?,?,?,
                            ?,?,
                            ?,?,?, 'checked_out')
                ");

                $purpose = "Imported record";
                $phone = "";
                $email = "";
                $company = "";
                $gender = "";
                $address = "";

                // Combine checkout date + time
                $checkout_time = ($checkout_date && $out_time)
                    ? $checkout_date . " " . $out_time
                    : null;

                $stmt->bind_param(
                    "sssssssssssssss",
                    $name,
                    $phone,
                    $email,
                    $company,
                    $gender,
                    $address,
                    $purpose,
                    $host_id,
                    $dept_id,
                    $checkin_date,
                    $in_time,
                    $checkout_time,
                    $tag,
                    $items
                );

                if ($stmt->execute()) $imported++;
                else $skipped++;
            }

            $msg = "Import Completed. Imported: $imported, Skipped: $skipped";

        } catch (Exception $e) {
            $error = "Error reading file: " . $e->getMessage();
        }
    }
}
?>

<h3 class="mb-4">Import Old Visitor Records</h3>

<?php if ($msg): ?>
<div class="alert alert-success"><?php echo $msg; ?></div>
<?php endif; ?>

<?php if ($error): ?>
<div class="alert alert-danger"><?php echo $error; ?></div>
<?php endif; ?>

<form method="POST" enctype="multipart/form-data" class="p-4 bg-white shadow-sm rounded">
    <label class="form-label fw-bold">Select Excel File (.xlsx)</label>
    <input type="file" name="excel_file" class="form-control" required>

    <button class="btn btn-primary mt-3 px-4">
        Import Now
    </button>
</form>

<?php include __DIR__ . '/../includes/footer.php'; ?>