<?php

if (!isset($_SESSION['username'])) {
    header("Location: index.php?page=login");
    exit;
}

$userModel = new User($conn);
$user = $userModel->getByUsername($_SESSION['username']);

$error = "";
$success = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $old = $_POST['old_password'];
    $new = $_POST['new_password'];
    $confirm = $_POST['confirm_password'];

    // Check empty
    if (!$old || !$new || !$confirm) {
        $error = "All fields are required.";
    }
    // Check new passwords match
    elseif ($new !== $confirm) {
        $error = "New passwords do not match.";
    }
    // Check old password
    elseif (!password_verify($old, $user['password'])) {
        $error = "Old password is incorrect.";
    }
    else {
        // Hash new password
        $newHash = password_hash($new, PASSWORD_DEFAULT);

        if ($userModel->updatePassword($_SESSION['username'], $newHash)) {
            $success = "Password updated successfully.";
        } else {
            $error = "Failed to update password.";
        }
    }
}

$page_title = "Change Password";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/change-password.php';
include __DIR__ . '/../views/layouts/footer.php';