<?php

require_permission('manage_departments');

$departmentModel = new Department($conn);
$departments = $departmentModel->getAll();

$editData = null;

// Load edit data
if (isset($_GET['edit'])) {
    $editData = $departmentModel->find($_GET['edit']);
}

// Handle save (create or update)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name = trim($_POST['name']);
    $description = trim($_POST['description']);

    if (!empty($_POST['id'])) {
        $departmentModel->update($_POST['id'], $name, $description);
    } else {
        $departmentModel->create($name, $description);
    }

    header("Location: index.php?page=departments");
    exit;
}

// Handle delete
if (isset($_GET['delete'])) {
    $departmentModel->delete($_GET['delete']);
    header("Location: index.php?page=departments");
    exit;
}

// LOAD LAYOUT
include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/layouts/sidebar.php';
include __DIR__ . '/../views/departments.php';
include __DIR__ . '/../views/layouts/footer.php';