<?php

require_permission('manage_employees');

$departmentModel = new Department($conn);
$employeeModel   = new Employee($conn);

$message = "";

// Handle file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {

    $file = $_FILES['csv_file']['tmp_name'];

    if (!file_exists($file)) {
        die("CSV file not found.");
    }

    // Read CSV
    if (($handle = fopen($file, "r")) !== FALSE) {

        // Skip header row
        fgetcsv($handle);

        while (($row = fgetcsv($handle, 1000, ",")) !== FALSE) {

            $name       = trim($row[0] ?? "");
            $email      = trim($row[1] ?? "");
            $phone      = trim($row[2] ?? "");
            $deptName   = trim($row[3] ?? "");

            if ($name === "") continue; // skip empty rows

            // Lookup or create department
            $departmentId = null;

            if ($deptName !== "") {

                // Does this department already exist?
                $stmt = $conn->prepare("SELECT id FROM departments WHERE name = ?");
                $stmt->bind_param("s", $deptName);
                $stmt->execute();
                $stmt->bind_result($departmentId);
                $stmt->fetch();
                $stmt->close();

                // Create department if not found
                if (!$departmentId) {
                    $departmentModel->create($deptName, "");
                    $departmentId = $conn->insert_id;
                }
            }

            // Insert employee
            $employeeModel->create($name, $email, $phone, $departmentId);
        }

        fclose($handle);
    }

    $message = "Employees imported successfully.";
}

// Reload layout
header("Location: index.php?page=employees&uploaded=1");
exit;