<?php

$page_title = "Login";

// If already logged in → redirect
if (isset($_SESSION['user_id'])) {
    header("Location: index.php?page=dashboard");
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    $userModel = new User($conn);
    $user = $userModel->findByUsername($username);

    if (!$user) {
        $error = "Invalid username or password.";
    } 
    else {

        $sha256_hash = hash('sha256', $password);

        // --------------------------------------------------------
        // CASE 1: OLD SHA256 password → auto-upgrade to bcrypt
        // --------------------------------------------------------
        if ($user['password'] === $sha256_hash) {

            $newHash = password_hash($password, PASSWORD_DEFAULT);
            $userModel->updatePassword($user['username'], $newHash);

            // Set login session
            $_SESSION['user_id']  = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role_id']  = $user['role_id'];
            $_SESSION['name']     = $user['username'];

            // Load permissions dynamically
            load_user_permissions($conn, $user['role_id']);

            header("Location: index.php?page=dashboard");
            exit;
        }

        // --------------------------------------------------------
        // CASE 2: bcrypt password
        // --------------------------------------------------------
        elseif (password_verify($password, $user['password'])) {

            $_SESSION['user_id']  = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role_id']  = $user['role_id'];
            $_SESSION['name']     = $user['username'];

            // Load permissions dynamically
            load_user_permissions($conn, $user['role_id']);

            header("Location: index.php?page=dashboard");
            exit;
        }

        // --------------------------------------------------------
        // CASE 3: Invalid password
        // --------------------------------------------------------
        else {
            $error = "Invalid username or password.";
        }
    }
}

include __DIR__ . '/../views/login.php';



// =================================================================
// Helper function: Load permissions for logged in user
// =================================================================
function load_user_permissions($conn, $role_id)
{
    $stmt = $conn->prepare("
        SELECT p.key 
        FROM role_permissions rp
        JOIN permissions p ON rp.permission_id = p.id
        WHERE rp.role_id = ?
    ");
    $stmt->bind_param("i", $role_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $permissions = [];
    while ($row = $result->fetch_assoc()) {
        $permissions[] = $row['key'];
    }

    $_SESSION['permissions'] = $permissions;
}