<?php

require_permission('reports_view');

$status = $_GET['status'] ?? 'all';
$start  = $_GET['start'] ?? null;
$end    = $_GET['end'] ?? null;
$q      = $_GET['q'] ?? null;

/*
---------------------------------------
 BASE QUERY
---------------------------------------
*/
$sql = "
    SELECT v.*, 
           e.name AS host_name,
           d.name AS department_name
    FROM visitors v
    LEFT JOIN employees   e ON v.host_id = e.id
    LEFT JOIN departments d ON v.department_id = d.id
    WHERE 1 = 1
";

/*
---------------------------------------
 FILTER — STATUS
---------------------------------------
*/
if ($status !== 'all') {
    $allowed = ['checked_in','checked_out','expected','inducted','returning'];
    if (in_array($status, $allowed)) {
        $sql .= " AND v.status = '{$status}' ";
    }
}

/*
---------------------------------------
 FILTER — DATE RANGE
---------------------------------------
*/
if ($start && $end) {
    $sql .= " AND DATE(v.created_at) BETWEEN '$start' AND '$end' ";
}

/*
---------------------------------------
 FILTER — SEARCH
---------------------------------------
*/
if ($q) {
    $q = $conn->real_escape_string($q);
    $sql .= "
        AND (
            v.name LIKE '%$q%' OR
            v.phone LIKE '%$q%' OR
            v.tag_number LIKE '%$q%' OR
            v.company LIKE '%$q%'
        )
    ";
}

/*
---------------------------------------
 ORDER
---------------------------------------
*/
$sql .= " ORDER BY v.id DESC ";

/*
---------------------------------------
 PAGINATION
---------------------------------------
*/
$limitOptions = [10,25,50,100];
$limit = (isset($_GET['limit']) && in_array((int)$_GET['limit'], $limitOptions))
         ? (int)$_GET['limit']
         : 10;

$page = isset($_GET['p']) && (int)$_GET['p'] > 0 ? (int)$_GET['p'] : 1;
$offset = ($page - 1) * $limit;

/*
---------------------------------------
 TOTAL ROW COUNT
---------------------------------------
*/
$countQuery = "
    SELECT COUNT(*) AS total
    FROM visitors v
    LEFT JOIN employees e ON v.host_id = e.id
    LEFT JOIN departments d ON v.department_id = d.id
    WHERE 1 = 1
";

if ($status !== 'all') {
    $countQuery .= " AND v.status = '{$status}' ";
}

if ($start && $end) {
    $countQuery .= " AND DATE(v.created_at) BETWEEN '$start' AND '$end' ";
}

if ($q) {
    $countQuery .= "
        AND (
            v.name LIKE '%$q%' OR
            v.phone LIKE '%$q%' OR
            v.tag_number LIKE '%$q%' OR
            v.company LIKE '%$q%'
        )
    ";
}

$totalRows = $conn->query($countQuery)->fetch_assoc()['total'];
$totalPages = max(1, ceil($totalRows / $limit));

/*
---------------------------------------
 RUN FINAL QUERY
---------------------------------------
*/
$sql .= " LIMIT $limit OFFSET $offset ";
$records = $conn->query($sql);

/*
---------------------------------------
 RENDER VIEW
---------------------------------------
*/

$page_title = "Visitor Reports";

include __DIR__ . '/../views/layouts/header.php';
include __DIR__ . '/../views/reports.php';
include __DIR__ . '/../views/layouts/footer.php';