<?php
require_once __DIR__ . '/config.php'; // DB + settings helpers

function get_purchase_code() {
    return trim(setting('license_purchase_code', ''));
}

function set_purchase_code($code) {
    // store hashed to avoid plain text
    $hash = password_hash($code, PASSWORD_DEFAULT);
    setting_set('license_purchase_code', $hash);
    setting_set('license_status', 'verified'); // you can set after remote check
    setting_set('license_last_check', date('Y-m-d H:i:s'));
}

function license_is_valid() {
    $status = setting('license_status', 'unverified');
    $storedHash = setting('license_purchase_code', '');
    if (empty($storedHash)) {
        return false;
    }

    // You can choose to store plain hash only and not be able to revalidate;
    // or store code separately during install and compare.
    // For simplicity, we accept non-empty + status verified:
    return $status === 'verified';
}

// Optional: remote verification stub
function verify_purchase_code_remote($code) {
    // TODO: implement call to your license server or Envato API.
    // For now we simulate always true:
    return true;
}