<?php

class Employee
{
    private $conn;

    public function __construct($conn)
    {
        $this->conn = $conn;
    }

    public function getAll()
    {
        $sql = "
            SELECT e.*, d.name AS department_name
            FROM employees e
            LEFT JOIN departments d ON e.department_id = d.id
            ORDER BY e.id ASC
        ";
        return $this->conn->query($sql);
    }

    public function find($id)
    {
        $stmt = $this->conn->prepare("SELECT * FROM employees WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function create($name, $email, $phone, $department_id)
    {
        $stmt = $this->conn->prepare("
            INSERT INTO employees (name, email, phone, department_id)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->bind_param("sssi", $name, $email, $phone, $department_id);
        return $stmt->execute();
    }

    public function update($id, $name, $email, $phone, $department_id)
    {
        $stmt = $this->conn->prepare("
            UPDATE employees 
            SET name=?, email=?, phone=?, department_id=? 
            WHERE id=?
        ");
        $stmt->bind_param("sssii", $name, $email, $phone, $department_id, $id);
        return $stmt->execute();
    }

    public function delete($id)
    {
        $stmt = $this->conn->prepare("DELETE FROM employees WHERE id=?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }
}