<?php

class User
{
    private $conn;

    public function __construct($conn)
    {
        $this->conn = $conn;
    }

    public function all()
    {
        return $this->conn->query("
            SELECT u.*, r.name AS role_name, d.name AS department_name
            FROM users u
            LEFT JOIN roles r ON u.role_id = r.id
            LEFT JOIN departments d ON u.department_id = d.id
            ORDER BY u.id ASC
        ");
    }

    public function find($id)
    {
        $stmt = $this->conn->prepare("
            SELECT * FROM users WHERE id = ?
        ");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function findByUsername($username)
{
    $stmt = $this->conn->prepare("SELECT * FROM users WHERE username = ? LIMIT 1");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

public function getByUsername($username)
{
    $sql = "SELECT * FROM users WHERE username = ? LIMIT 1";
    $stmt = $this->conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}
public function updatePassword($username, $hash)
{
    $sql = "UPDATE users SET password = ? WHERE username = ?";
    $stmt = $this->conn->prepare($sql);
    $stmt->bind_param("ss", $hash, $username);
    return $stmt->execute();
}

    public function create($username, $email, $password, $role_id, $department_id)
    {
        $stmt = $this->conn->prepare("
            INSERT INTO users(username, email, password, role_id, department_id, language, theme)
            VALUES (?, ?, ?, ?, ?, 'en', 'light')
        ");
        $stmt->bind_param("sssii", $username, $email, $password, $role_id, $department_id);
        return $stmt->execute();
    }

    public function update($id, $email, $role_id, $department_id)
    {
        $stmt = $this->conn->prepare("
            UPDATE users 
            SET email = ?, role_id = ?, department_id = ?
            WHERE id = ?
        ");
        $stmt->bind_param("siii", $email, $role_id, $department_id, $id);
        return $stmt->execute();
    }

    public function delete($id)
    {
        // prevent deleting system admin account
        if ($id == 1) return false;

        $stmt = $this->conn->prepare("DELETE FROM users WHERE id = ?");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }
}