<?php
// app/models/Dashboard.php

class Dashboard
{
    private $conn;

    public function __construct($conn)
    {
        $this->conn = $conn;
    }

    public function getStats()
    {
        $stats = [];

        // Total visitors
        $sql = "SELECT COUNT(*) AS total FROM visitors";
        $result = $this->conn->query($sql);
        $row = $result->fetch_assoc();
        $stats['total_visitors'] = (int) ($row['total'] ?? 0);

        // Today's visitors (based on checkin_date OR created_at if empty)
        $sql = "
            SELECT COUNT(*) AS total 
            FROM visitors 
            WHERE (checkin_date = CURDATE() OR DATE(created_at) = CURDATE())
        ";
        $result = $this->conn->query($sql);
        $row = $result->fetch_assoc();
        $stats['visitors_today'] = (int) ($row['total'] ?? 0);

        // Visitors by status
        $stats['status_counts'] = [
            'expected'    => 0,
            'checked_in'  => 0,
            'checked_out' => 0,
            'returning'   => 0,
        ];

        $sql = "SELECT status, COUNT(*) AS total FROM visitors GROUP BY status";
        $result = $this->conn->query($sql);
        while ($row = $result->fetch_assoc()) {
            $status = $row['status'];
            if (isset($stats['status_counts'][$status])) {
                $stats['status_counts'][$status] = (int) $row['total'];
            }
        }

        // Overstay (based on overstay_notified flag)
        $sql = "SELECT COUNT(*) AS total FROM visitors WHERE overstay_notified = 1";
        $result = $this->conn->query($sql);
        $row = $result->fetch_assoc();
        $stats['overstays'] = (int) ($row['total'] ?? 0);

        // Induction stats
        $stats['induction_counts'] = [
            'Pending'  => 0,
            'Inducted' => 0,
        ];

        $sql = "SELECT status, COUNT(*) AS total FROM induction GROUP BY status";
        $result = $this->conn->query($sql);
        while ($row = $result->fetch_assoc()) {
            $status = $row['status'];
            if (isset($stats['induction_counts'][$status])) {
                $stats['induction_counts'][$status] = (int) $row['total'];
            }
        }

        return $stats;
    }
}