<?php

class Induction
{
    private $conn;

    public function __construct($conn)
    {
        $this->conn = $conn;
    }

    // Create a new induction
    public function create($data)
    {
        $sql = "
            INSERT INTO induction
                (name, phone, email, organization, induction_date, status)
            VALUES (?, ?, ?, ?, CURDATE(), 'Pending')
        ";

        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param(
            "ssss",
            $data['name'],
            $data['phone'],
            $data['email'],
            $data['organization']
        );

        return $stmt->execute();
    }

    // Get all induction records
    public function getAll()
    {
        return $this->conn->query("
            SELECT * FROM induction ORDER BY id DESC
        ");
    }

    // Find one induction record
    public function find($id)
    {
        $stmt = $this->conn->prepare("SELECT * FROM induction WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    // Mark as inducted
    public function markInducted($id)
    {
        $stmt = $this->conn->prepare("
            UPDATE induction SET status = 'Inducted' WHERE id = ?
        ");
        $stmt->bind_param("i", $id);
        return $stmt->execute();
    }
}