<?php
// app/views/checkedin.php
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="fw-semibold">Checked-In Visitors</h2>
</div>

<div class="card shadow-sm">
    <div class="card-body p-0">

        <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th style="width:50px;">#</th>
                    <th>Name</th>
                    <th>Company</th>
                    <th>Host</th>
                    <th>Department</th>
                    <th>Check-In Time</th>
                    <th>Tag No.</th>
                    <th style="width:120px;">Action</th>
                </tr>
            </thead>

            <tbody>
                <?php 
                $num = 1;
                while ($row = $checkedin->fetch_assoc()):
                ?>

                <tr>
                    <td><?= $num++ ?></td>

                    <td>
                        <strong><?= htmlspecialchars($row['name'] ?? '') ?></strong><br>
                        <small class="text-muted"><?= htmlspecialchars($row['phone'] ?? '') ?></small>
                    </td>

                    <td><?= htmlspecialchars($row['company'] ?? '') ?></td>

                    <td><?= htmlspecialchars($row['host_name'] ?? '') ?></td>

                    <td><?= htmlspecialchars($row['department_name'] ?? '') ?></td>

                    <td>
                        <span class="badge bg-primary">
                            <?= htmlspecialchars(date("Y-m-d H:i", strtotime($row['checkin_datetime'] ?? ''))) ?>
                        </span>
                    </td>

                    <td>
                        <span class="badge bg-dark"><?= htmlspecialchars($row['tag_number'] ?? '—') ?></span>
                    </td>

                    <td>
                        <a href="index.php?page=visitor-checkout&id=<?= $row['id'] ?>"
                           class="btn btn-danger btn-sm w-100">
                            <i class="bi bi-door-closed"></i> Checkout
                        </a>
                    </td>
                </tr>

                <?php endwhile; ?>
            </tbody>

        </table>

    </div>
</div>