<div class="container-fluid">

    <h3 class="mb-4">Departments</h3>

    <div class="row">
        
        <!-- ADD / EDIT FORM -->
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-header bg-white fw-semibold">
                    Add / Edit Department
                </div>

                <div class="card-body">

                    <form method="post">
                        <input type="hidden" name="id" value="<?= $editData['id'] ?? '' ?>">

                        <div class="mb-3">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control"
                                   value="<?= htmlspecialchars($editData['name'] ?? '') ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea name="description" class="form-control" rows="3"><?= htmlspecialchars($editData['description'] ?? '') ?></textarea>
                        </div>

                        <button class="btn btn-primary">Save</button>
                        <a href="index.php?page=departments" class="btn btn-secondary">Clear</a>

                    </form>

                </div>
            </div>
        </div>

        <!-- TABLE -->
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-body">

                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Description</th>
                                <th>Action</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $i = 1; while ($d = $departments->fetch_assoc()): ?>
                            <tr>
                                <td><?= $i++ ?></td>
                                <td><?= htmlspecialchars($d['name'] ?? '') ?></td>
                                <td><?= htmlspecialchars($d['description'] ?? '') ?></td>

                                <td>
                                    <a href="index.php?page=departments&edit=<?= $d['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
                                    <a href="index.php?page=departments&delete=<?= $d['id'] ?>" 
                                       onclick="return confirm('Delete this department?')" 
                                       class="btn btn-sm btn-danger">Delete</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>

                    </table>

                </div>
            </div>
        </div>

    </div>

</div>