<div class="container-fluid">

<h2 class="mb-4">Induction Report</h2>

<!-- FILTER FORM -->
<form method="get" class="row g-3 mb-4">
    <input type="hidden" name="page" value="induction-report">

    <div class="col-md-3">
        <label class="form-label">Start Date</label>
        <input type="date" name="start" class="form-control"
               value="<?= htmlspecialchars($_GET['start'] ?? '') ?>">
    </div>

    <div class="col-md-3">
        <label class="form-label">End Date</label>
        <input type="date" name="end" class="form-control"
               value="<?= htmlspecialchars($_GET['end'] ?? '') ?>">
    </div>

    <div class="col-md-3 d-flex align-items-end">
        <button class="btn btn-primary w-100">Filter</button>
    </div>

    <div class="col-md-3 d-flex align-items-end">
        <a href="index.php?page=induction-report" class="btn btn-secondary w-100">Reset</a>
    </div>
</form>

<!-- RESULTS TABLE -->
<div class="card shadow-sm">
    <div class="card-body">

        <table class="table table-hover align-middle">
            <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Company</th>
                    <th>Phone</th>
                    <th>Induction Date</th>
                    <th>Host</th>
                    <th>Department</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                <?php if ($records->num_rows > 0): ?>
                    <?php $i = 1; while($v = $records->fetch_assoc()): ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td><?= htmlspecialchars($v['name']) ?></td>
                            <td><?= htmlspecialchars($v['company']) ?></td>
                            <td><?= htmlspecialchars($v['phone']) ?></td>
                            <td><?= htmlspecialchars($v['induction_date'] ?? '') ?></td>
                            <td><?= htmlspecialchars($v['host_name'] ?? '') ?></td>
                            <td><?= htmlspecialchars($v['department_name'] ?? '') ?></td>
                            <td>
                                <a href="index.php?page=visitor-view&id=<?= $v['id'] ?>"
                                   class="btn btn-sm btn-outline-primary">View</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center py-3">
                            No induction records found.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>

        </table>

    </div>
</div>

</div>