<h2>Visitor Induction</h2>

<?php if (!empty($success)): ?>
<div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<?php if (!empty($error)): ?>
<div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>


<!-- INDUCTION FORM -->
<div class="card shadow-sm mb-4">
    <div class="card-body">

        <form method="post">

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="form-label">Full Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="col-md-3 mb-3">
                    <label class="form-label">Phone Number</label>
                    <input type="text" name="phone" class="form-control" required>
                </div>

                <div class="col-md-3 mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control">
                </div>

                <div class="col-md-3 mb-3">
                    <label class="form-label">Company (optional)</label>
                    <input type="text" name="company" class="form-control">
                </div>
            </div>

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Department</label>
                    <select name="department_id" class="form-select" required>
                        <option value="">-- Select --</option>
                        <?php while ($d = $departments->fetch_assoc()): ?>
                            <option value="<?= $d['id'] ?>">
                                <?= htmlspecialchars($d['name']) ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>

            <button class="btn btn-success">Save Induction</button>

        </form>

    </div>
</div>


<!-- RECENT INDUCTIONS -->
<h4 class="text-primary">Recent Inductions</h4>

<div class="card shadow-sm">
    <div class="card-body p-0">

        <table class="table mb-0">
            <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Company</th>
                    <th>Department</th>
                    <th>Induction Time</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                <?php $n = 1; ?>
                <?php while ($row = $inductions->fetch_assoc()): ?>

                    <tr>
                        <td><?= $n++ ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= htmlspecialchars($row['phone']) ?></td>
                        <td><?= htmlspecialchars($row['email']) ?></td>
                        <td><?= htmlspecialchars($row['company'] ?: '-') ?></td>
                        <td><?= htmlspecialchars($row['department_name'] ?: '-') ?></td>

                        <td>
                            <?= $row['induction_datetime']
                                ? date('Y-m-d H:i', strtotime($row['induction_datetime']))
                                : '-' ?>
                        </td>

                        <td>
                            <a href="index.php?page=visitor-checkin&returning=<?= $row['id'] ?>"
                               class="btn btn-sm btn-primary">
                                Proceed to Check-in
                            </a>
                        </td>
                    </tr>

                <?php endwhile; ?>
            </tbody>

        </table>

    </div>
</div>