<?php
// app/views/returning-visitor.php
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">Returning Visitor</h2>
    <a href="index.php?page=visitor-checkin" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-person-plus"></i> New Check-In
    </a>
</div>

<div class="card shadow-sm mb-4">
    <div class="card-body">
        <form class="row g-2" method="get" action="index.php">
            <input type="hidden" name="page" value="returning-visitor">

            <div class="col-md-6">
                <label class="form-label">Search Visitor</label>
                <input type="text"
                       name="q"
                       class="form-control"
                       placeholder="Search by Name, Phone or Tag number"
                       value="<?= htmlspecialchars($search ?? '') ?>">
            </div>

            <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-primary w-100">
                    <i class="bi bi-search"></i> Search
                </button>
            </div>

            <div class="col-md-3 d-flex align-items-end">
                <a href="index.php?page=returning-visitor" class="btn btn-outline-secondary w-100">
                    Reset
                </a>
            </div>
        </form>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-body p-0">
        <table class="table mb-0 table-hover align-middle">
            <thead class="table-light">
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Company</th>
                <th>Tag No.</th>
                <th>Status</th>
                <th>Last Check-In</th>
                <th>Action</th>
            </tr>
            </thead>
            <tbody>
            <?php if ($results && $results->num_rows > 0): ?>
                <?php $i = 1; while ($row = $results->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= htmlspecialchars($row['phone']) ?></td>
                        <td><?= htmlspecialchars($row['company'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['tag_number'] ?? '') ?></td>
                        <td>
                            <?php if ($row['status'] === 'checked_in'): ?>
                                <span class="badge bg-success">Checked In</span>
                            <?php elseif ($row['status'] === 'checked_out'): ?>
                                <span class="badge bg-secondary">Checked Out</span>
                            <?php elseif ($row['status'] === 'returning'): ?>
                                <span class="badge bg-info text-dark">Returning</span>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark">Expected</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?= $row['checkin_datetime'] ? htmlspecialchars($row['checkin_datetime']) : '-' ?>
                        </td>
                        <td>
                            <a href="index.php?page=visitor-checkin&returning=<?= (int)$row['id'] ?>"
                               class="btn btn-sm btn-primary">
                                Re-Check-In
                            </a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" class="text-center py-4">
                        No visitors found. Try another search.
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>