<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Users</h2>
    <a href="index.php?page=users-create" class="btn btn-primary">
        <i class="bi bi-person-plus"></i> Create User
    </a>
</div>

<div class="card shadow-sm border-0">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Department</th>
                    <th>Role</th>
                    <th>Created</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>

            <?php while ($u = $users->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($u['username']) ?></td>
                    <td><?= $u['email'] ?: '-' ?></td>
                    <td><?= $u['department_name'] ?: '-' ?></td>
                    <td><?= $u['role_name'] ?></td>
                    <td><?= $u['created_at'] ?></td>

                    <td class="text-end">
                        <a href="index.php?page=users-edit&id=<?= $u['id'] ?>" 
                           class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-pencil"></i>
                        </a>

                        <?php if ($u['id'] != 1): ?>
                        <a href="index.php?page=users-delete&id=<?= $u['id'] ?>" 
                           class="btn btn-sm btn-outline-danger"
                           onclick="return confirm('Delete this user?')">
                            <i class="bi bi-trash"></i>
                        </a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endwhile; ?>

            </tbody>
        </table>
    </div>
</div>
=