<?php // Visitor Check-In Page ?>

<div class="row mb-4">
    <div class="col-12 d-flex justify-content-between align-items-center">
        <h2 class="mb-0">Visitor Check-In</h2>
        <a href="index.php?page=checkedin" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-list"></i> View Checked-In Visitors
        </a>
    </div>
</div>

<?php if (!empty($error)): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-body">

        <form method="post" enctype="multipart/form-data">

            <!-- Check-In Details -->
            <h5 class="mb-3 fw-bold">Section 1 — Check-In Details</h5>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Check-In Date</label>
                    <input type="date" name="checkin_date" class="form-control" 
                        value="<?= htmlspecialchars($defaultDate) ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Check-In Time</label>
                    <input type="time" name="checkin_time" class="form-control" 
                        value="<?= htmlspecialchars($defaultTime) ?>">
                </div>
            </div>

            <hr class="my-4">

            <!-- Visitor Information -->
            <h5 class="fw-bold mb-3">Visitor Information</h5>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Full Names</label>
                    <input type="text" name="name" class="form-control" 
                        value="<?= htmlspecialchars($returningData['name'] ?? '') ?>" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Company</label>
                    <input type="text" name="company" class="form-control" 
                        value="<?= htmlspecialchars($returningData['company'] ?? '') ?>">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Phone Number</label>
                    <input type="text" name="phone" class="form-control" required
                        value="<?= htmlspecialchars($returningData['phone'] ?? '') ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control"
                        value="<?= htmlspecialchars($returningData['email'] ?? '') ?>">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Gender</label>
                    <select name="gender" class="form-select">
                        <option value="">-- Select Gender --</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Address</label>
                    <input type="text" name="address" class="form-control">
                </div>
            </div>

            <!-- PHOTO + ATTACHMENT ROW -->
<div class="row">

    <!-- Capture Photo -->
    <div class="col-md-6 mb-3">
        <label class="form-label">Visitor Photo</label>

        <div class="d-flex align-items-center gap-3">

            <!-- Hidden File Input -->
            <input type="file" name="photo" id="photoInput" class="d-none">

            <!-- Capture Button -->
            <button type="button" class="btn btn-primary" onclick="openCamera()">
                <i class="bi bi-camera"></i> Capture Photo
            </button>

            <!-- Preview Image -->
            <img id="photoPreviewImg"
                 src=""
                 style="width:60px; height:60px; object-fit:cover; border-radius:6px; display:none; border:1px solid #ccc;">
        </div>
    </div>

    <!-- Attachments -->
    <div class="col-md-6 mb-3">
        <label class="form-label">Attachments</label>
        <input type="file" name="attachment" class="form-control">
    </div>

</div>

<!-- CAMERA POPUP -->
<div class="modal fade" id="cameraModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Capture Visitor Photo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body text-center">

                <video id="cameraStream"
                       autoplay
                       playsinline
                       style="width:100%; border-radius:8px;">
                </video>

                <canvas id="captureCanvas" class="d-none"></canvas>

                <button class="btn btn-success mt-3" onclick="capturePhoto()">
                    <i class="bi bi-camera-fill"></i> Capture
                </button>

            </div>

        </div>
    </div>
</div>

            <hr class="my-4">

            <!-- Host Section -->
            <h5 class="fw-bold mb-3">Host Information</h5>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Select Host</label>
                    <select name="host_id" class="form-select" required>
                        <option value="">-- Select Host --</option>
                        <?php while ($h = $hosts->fetch_assoc()): ?>
                            <option value="<?= $h['id'] ?>"><?= htmlspecialchars($h['name']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Department</label>
                    <select name="department_id" class="form-select" required>
                        <option value="">-- Select Department --</option>
                        <?php while ($d = $departments->fetch_assoc()): ?>
                            <option value="<?= $d['id'] ?>"><?= htmlspecialchars($d['name']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Purpose of Visit</label>
                <textarea name="purpose" class="form-control" rows="2"></textarea>
            </div>

            <hr class="my-4">

            <!-- Security -->
            <h5 class="fw-bold mb-3">Security Section</h5>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Items Declared</label>
                    <input type="text" name="items_declared" class="form-control">
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Visitor Tag Number</label>
                    <input type="text" name="tag_number" class="form-control">
                </div>
            </div>

            <div class="d-flex justify-content-end mt-4">
                <button class="btn btn-success btn-lg">
                    Check-In Visitor
                </button>
            </div>

        </form>

    </div>
    <script>
// Open Camera
function openCamera() {
    const modal = new bootstrap.Modal(document.getElementById('cameraModal'));
    modal.show();

    navigator.mediaDevices.getUserMedia({ video: true })
        .then(stream => {
            document.getElementById('cameraStream').srcObject = stream;
        })
        .catch(err => {
            alert("Camera access denied or unavailable.");
        });
}

// Capture and Convert to File Input
function capturePhoto() {
    const video = document.getElementById('cameraStream');
    const canvas = document.getElementById('captureCanvas');
    const preview = document.getElementById('photoPreviewImg');
    const input = document.getElementById('photoInput');

    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;

    // Draw video frame into canvas
    canvas.getContext('2d').drawImage(video, 0, 0);

    // Convert to data URL
    const dataURL = canvas.toDataURL("image/jpeg");

    // Show preview
    preview.src = dataURL;
    preview.style.display = "block";

    // Convert base64 → Blob → File and attach to <input type="file">
    fetch(dataURL)
        .then(res => res.arrayBuffer())
        .then(buffer => {
            const file = new File([buffer], "photo.jpg", { type: "image/jpeg" });

            // Create DataTransfer to inject file into input
            const dt = new DataTransfer();
            dt.items.add(file);
            input.files = dt.files;
        });

    // Close popup
    bootstrap.Modal.getInstance(document.getElementById('cameraModal')).hide();

    // Stop camera
    stopCamera();
}

function stopCamera() {
    const stream = document.getElementById('cameraStream').srcObject;
    if (stream) {
        stream.getTracks().forEach(track => track.stop());
    }
}
</script>
</div>