<?php
// Safe escape helper
if (!function_exists('e')) {
    function e($v) {
        return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
    }
}

// Load company logo from settings
$companyLogo = setting('company_logo', 'assets/images/logo.png');

$photo = $visitor['photo'] ?: null;
$qr    = $visitor['qr_code_path'] ?? null;
?>

<style>
.badge-card {
    width: 350px;
    border: 2px solid #000;
    margin: 0 auto;
    padding: 20px;
    font-family: Arial, sans-serif;
    position: relative;
}

.badge-title {
    text-align: center;
    font-size: 20px;
    font-weight: bold;
}

.badge-logo {
    text-align: center;
    margin-bottom: 10px;
}

.badge-logo img {
    max-height: 60px;
}

.badge-photo {
    width: 120px;
    height: 120px;
    border: 1px solid #aaa;
    margin: 10px auto;
    display: flex;
    justify-content: center;
    align-items: center;
}

.badge-section {
    margin-top: 10px;
    font-size: 14px;
}

.badge-section strong {
    font-weight: bold;
}

.qr-box {
    text-align: center;
    margin-top: 20px;
}

.print-controls {
    text-align: center;
    margin-top: 20px;
}

/* Hide buttons during printing */
@media print {
    .no-print {
        display: none !important;
    }
}

</style>

<div class="badge-card">

    <!-- ⬅ Back Button -->
    <div class="no-print" style="position:absolute; top:10px; right:10px;">
        <a href="index.php?page=visitor-view&id=<?= e($visitor['id']) ?>" class="btn btn-secondary btn-sm">
            Back
        </a>
    </div>

    <!-- Company Logo -->
    <div class="badge-logo">
        <img src="<?= e($companyLogo) ?>" alt="Company Logo">
    </div>

    <div class="badge-title">WS Visitor Gate Pass</div>
    <hr>

    <!-- Visitor Photo -->
    <div class="badge-photo">
        <?php if ($photo && file_exists($photo)): ?>
            <img src="<?= e($photo) ?>" style="max-width:100%; max-height:100%;">
        <?php else: ?>
            No Photo
        <?php endif; ?>
    </div>

    <h3 style="text-align:center; margin-top:10px;"><?= e($visitor['name']) ?></h3>

    <div class="badge-section"><strong>Host:</strong> <?= e($visitor['host_name'] ?? '—') ?></div>
    <div class="badge-section"><strong>Department:</strong> <?= e($visitor['department_name'] ?? '—') ?></div>
    <div class="badge-section"><strong>Purpose:</strong> <?= e($visitor['purpose'] ?? '—') ?></div>
    <div class="badge-section"><strong>Checked In:</strong> <?= e($visitor['checkin_datetime'] ?? '—') ?></div>

    <!-- QR Code -->
    <div class="qr-box">
        <?php if ($qr && file_exists($qr)): ?>
            <img src="<?= e($qr) ?>" width="140">
        <?php else: ?>
            <div style="color:#888;">No QR Code</div>
        <?php endif; ?>
    </div>

    <!-- Print Button -->
    <div class="print-controls no-print">
        <button onclick="window.print()" class="btn btn-primary">Print Badge</button>
    </div>

</div>