<?php
// Null-safe escape helper
function e($v) {
    return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8');
}

// Fallbacks for missing join values
$hostName       = $visitor['host_name']       ?? '—';
$departmentName = $visitor['department_name'] ?? '—';

// Fix status formatting
$status = ucfirst(str_replace('_', ' ', $visitor['status'] ?? 'unknown'));
?>

<div class="row">
    <!-- LEFT SIDE -->
    <div class="col-lg-8">

        <div class="card shadow-sm mb-4">
            <div class="card-body">

                <h3 class="fw-bold mb-3"><?= e($visitor['name']) ?></h3>

                <div class="mb-2"><strong>Phone:</strong> <?= e($visitor['phone']) ?></div>
                <div class="mb-2"><strong>Email:</strong> <?= e($visitor['email'] ?: '—') ?></div>
                <div class="mb-2"><strong>Company:</strong> <?= e($visitor['company'] ?: '—') ?></div>

                <div class="mb-2"><strong>Gender:</strong> <?= e($visitor['gender'] ?: '—') ?></div>

                <div class="mb-2"><strong>Host:</strong> <?= e($hostName) ?></div>

                <div class="mb-2"><strong>Department:</strong> <?= e($departmentName) ?></div>

                <div class="mb-2"><strong>Purpose:</strong> <?= e($visitor['purpose'] ?: '—') ?></div>

                <div class="mb-2"><strong>Items Declared:</strong> <?= e($visitor['items_declared'] ?: '—') ?></div>

                <div class="mb-2">
                    <strong>Tag Number:</strong> <?= e($visitor['tag_number'] ?: '—') ?>
                </div>

                <div class="mb-2">
                    <strong>Address:</strong> <?= e($visitor['address'] ?: '—') ?>
                </div>

                <hr>

                <!-- STATUS SECTION -->
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Status:</strong>
                        <span class="badge 
                            <?php if ($visitor['status'] === 'checked_in') echo 'bg-success';
                                  elseif ($visitor['status'] === 'checked_out') echo 'bg-secondary';
                                  elseif ($visitor['status'] === 'expected') echo 'bg-warning text-dark';
                                  else echo 'bg-dark'; ?>">
                            <?= e($status) ?>
                        </span>
                    </div>

                    <div class="col-md-6">
                        <strong>Check-in Time:</strong>
                        <?= e($visitor['checkin_datetime'] ?: '—') ?>
                    </div>
                </div>

                <div class="mb-2">
                    <strong>Check-out Time:</strong>
                    <?= e($visitor['checkout_time'] ?: '—') ?>
                </div>

            </div>
        </div>

    </div>


    <!-- RIGHT SIDE -->
    <div class="col-lg-4">

        <!-- PHOTO -->
        <div class="card shadow-sm mb-4">
            <div class="card-body text-center">

                <h5 class="fw-bold mb-2">Visitor Photo</h5>

                <?php if (!empty($visitor['photo'])): ?>
                    <img src="<?= e($visitor['photo']) ?>" 
                         class="img-fluid rounded mb-3" style="max-height: 250px;">
                <?php else: ?>
                    <div class="text-muted">No photo available</div>
                <?php endif; ?>

            </div>
        </div>

        <!-- QR CODE -->
        <div class="card shadow-sm mb-4">
            <div class="card-body text-center">

                <h5 class="fw-bold mb-3">QR Code</h5>

                <?php if (!empty($visitor['qr_code_path'])): ?>
                    <img src="<?= e($visitor['qr_code_path']) ?>" 
                         class="img-fluid" style="max-width: 200px;">
                <?php else: ?>
                    <div class="text-muted">QR code not generated</div>
                <?php endif; ?>

            </div>
        </div>

        <!-- ACTION BUTTONS -->
        <div class="card shadow-sm">
            <div class="card-body text-center">

                <a href="index.php?page=visitor-edit&id=<?= e($visitor['id']) ?>"
                   class="btn btn-warning w-100 mb-2 fw-bold">
                    Edit
                </a>

                <a href="index.php?page=visitor-print-badge&id=<?= e($visitor['id']) ?>"
                   class="btn btn-primary w-100 mb-2 fw-bold">
                    Print Badge
                </a>

                <?php if ($visitor['status'] === 'checked_in'): ?>
                    <a href="index.php?page=visitor-checkout&id=<?= e($visitor['id']) ?>"
                       class="btn btn-success w-100 mb-2 fw-bold">
                        Check-out
                    </a>
                <?php endif; ?>

                <a href="index.php?page=visitor-delete&id=<?= e($visitor['id']) ?>"
                   onclick="return confirm('Are you sure you want to delete this visitor?')"
                   class="btn btn-danger w-100 fw-bold">
                    Delete
                </a>

            </div>
        </div>

    </div>
</div>