<?php
// app/views/visitors.php
?>

<div class="row mb-4">
  <div class="col-12 d-flex justify-content-between align-items-center">
    
    <div>
      <h2>Visitors</h2>
      <?php if (isset($_GET['deleted'])): ?>
        <div class="alert alert-success mt-2">
            Visitor deleted successfully.
        </div>
      <?php endif; ?>
    </div>

    <div class="d-flex gap-2">
      <a href="index.php?page=visitor-new" class="btn btn-success">Add Visitor</a>
      <a href="index.php?page=visitor-checkin" class="btn btn-primary">New Check-in</a>
    </div>

  </div>
</div>

<div class="card shadow-sm border-0">
  <div class="card-body p-0">
    <div class="table-responsive">
      <table class="table table-hover mb-0">
        <thead class="table-light">
          <tr>
            <th>Name</th>
            <th>Company</th>
            <th>Host</th>
            <th>Department</th>
            <th>Status</th>
            <th>Check-in</th>
            <th>Check-out</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>

          <?php if ($visitors && $visitors->num_rows > 0): ?>
            <?php while ($v = $visitors->fetch_assoc()): ?>
              <tr>
                <td><?= htmlspecialchars($v['name']) ?></td>
                <td><?= htmlspecialchars($v['company']) ?></td>
                <td><?= htmlspecialchars($v['host_name']) ?></td>
                <td><?= htmlspecialchars($v['department_name']) ?></td>

                <td>
                  <?php if ($v['status'] === 'checked_in'): ?>
                    <span class="badge bg-success">Checked In</span>
                  <?php elseif ($v['status'] === 'checked_out'): ?>
                    <span class="badge bg-secondary">Checked Out</span>
                  <?php elseif ($v['status'] === 'returning'): ?>
                    <span class="badge bg-info">Returning</span>
                  <?php else: ?>
                    <span class="badge bg-warning text-dark">Expected</span>
                  <?php endif; ?>
                </td>

                <td><?= $v['checkin_datetime'] ?: '-' ?></td>
                <td><?= $v['checkout_time'] ?: '-' ?></td>

                <td>
                  <a href="index.php?page=visitor-view&id=<?= $v['id'] ?>" class="btn btn-sm btn-outline-primary">View</a>
                  <a href="index.php?page=visitor-edit&id=<?= $v['id'] ?>" class="btn btn-sm btn-outline-warning">Edit</a>
                </td>
              </tr>
            <?php endwhile; ?>

          <?php else: ?>
            <tr><td colspan="8" class="text-center py-4">No visitors found.</td></tr>
          <?php endif; ?>

        </tbody>
      </table>
    </div>
  </div>
</div>