<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
/**
 * ---------------------------------------------------------
 * GLOBAL BOOTSTRAP FILE
 * Loads everything needed for the MVC system to work.
 * ---------------------------------------------------------
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * ---------------------------------------------------------
 * Load Database Connection
 * ---------------------------------------------------------
 */
$dbConfigPath = __DIR__ . '/db.php';

if (!file_exists($dbConfigPath)) {
    die("Database configuration file not found: config/db.php");
}

require_once $dbConfigPath;  // This should define $conn (mysqli connection)

// Load helpers globally
foreach (glob(__DIR__ . '/../app/helpers/*.php') as $helperFile) {
    require_once $helperFile;
}


/**
 * ---------------------------------------------------------
 * Autoload MODELS
 * ---------------------------------------------------------
 */
foreach (glob(__DIR__ . '/../app/models/*.php') as $modelFile) {
    require_once $modelFile;
}


/**
 * ---------------------------------------------------------
 * Autoload HELPERS
 * ---------------------------------------------------------
 */
foreach (glob(__DIR__ . '/../app/helpers/*.php') as $helperFile) {
    require_once $helperFile;
}


/**
 * ---------------------------------------------------------
 * Optional GLOBAL SETTINGS
 * (You can add timezone, constants, other setup here)
 * ---------------------------------------------------------
 */
date_default_timezone_set('Africa/Lagos');