<?php
// cron/overstay_check.php
// Run this from cron or hit manually to send overstay alerts.

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/mailer.php';
require_once __DIR__ . '/../includes/notify.php';

// Overstay limit in HOURS from settings (default 4)
$limit_hours   = (float) setting_val('overstay_limit_hours', '4');
$limit_minutes = (int) round($limit_hours * 60);

// Find visitors still checked in beyond limit
$sql = "
  SELECT v.id, v.name, v.phone, v.purpose, v.checkin_time,
         e.name AS host_name
  FROM visitors v
  LEFT JOIN employees e ON v.host_id = e.id
  WHERE v.status IN ('checked_in','returning')
    AND TIMESTAMPDIFF(MINUTE, v.checkin_time, NOW()) > ?
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $limit_minutes);
$stmt->execute();
$res = $stmt->get_result();

while ($row = $res->fetch_assoc()) {
    notify_overstay($row, $limit_minutes);
}
