<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/phpmailer/src/PHPMailer.php';
require_once __DIR__ . '/phpmailer/src/SMTP.php';
require_once __DIR__ . '/phpmailer/src/Exception.php';

// Load shared helpers (includes DB + settings + split_emails)
require_once __DIR__ . '/functions.php';

/**
 * Send Email using PHPMailer
 */
function sendMail($to, $subject, $body) {

    // Normalise recipients into an array
    if (!is_array($to)) {
        $to = split_emails($to);
    }

    if (empty($to)) {
        return false;
    }

    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host       = setting_val('smtp_host', 'localhost');
        $mail->SMTPAuth   = true;
        $mail->Username   = setting_val('smtp_username', '');
        $mail->Password   = setting_val('smtp_password', '');
        $mail->Port       = (int) setting_val('smtp_port', 465);

        // SSL / TLS
        $enc = strtolower(setting_val('smtp_encryption', 'ssl'));
        if ($enc === 'tls') {
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        } else {
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
        }

        // From details
        $from_address = setting_val('vgp_email_from_address', 'noreply@example.com');
        $from_name    = setting_val('vgp_email_from_name', 'Visitor Gate Pass');
        $mail->setFrom($from_address, $from_name);

        // Recipients
        foreach ($to as $addr) {
            $mail->addAddress($addr);
        }

        $mail->isHTML(false);
        $mail->Subject = $subject;
        $mail->Body    = $body;

        $mail->send();
        return true;

    } catch (Exception $e) {
        // Log PHPMailer error for debugging
        error_log("PHPMailer Error: " . $mail->ErrorInfo);

        // Fallback to basic mail()
        $headers = "From: Visitor Gate Pass <noreply@example.com>";
        @mail(implode(",", $to), $subject, $body, $headers);

        return false;
    }
}