<?php
/**
 * Simple Pagination Helper
 * Usage:
 *   list($limitSql, $paginationHtml) = paginate($conn, $baseQuery, $params, $types);
 */

function paginate($conn, $query, $params = [], $types = '', $perPage = 20) {

    // Current page
    $page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
    $offset = ($page - 1) * $perPage;

    // Count total rows
    $countSql = "SELECT COUNT(*) AS total FROM ($query) AS sub";
    $stmt = $conn->prepare($countSql);

    if ($params) $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $total = $stmt->get_result()->fetch_assoc()['total'] ?? 0;

    // Limit SQL
    $limitSql = $query . " LIMIT $offset, $perPage";

    // Pagination HTML
    $pages = max(1, ceil($total / $perPage));
    $html = '<nav><ul class="pagination justify-content-center mt-3">';

    // Prev
    $prev = $page - 1;
    $html .= '<li class="page-item '.($page<=1?'disabled':'').'">
                <a class="page-link" href="?'.http_build_query(array_merge($_GET,['page'=>$prev])).'">&laquo;</a>
              </li>';

    // Page numbers
    for ($i = 1; $i <= $pages; $i++) {
        $html .= '<li class="page-item '.($page==$i?'active':'').'">
                    <a class="page-link" href="?'.http_build_query(array_merge($_GET,['page'=>$i])).'">'.$i.'</a>
                  </li>';
    }

    // Next
    $next = $page + 1;
    $html .= '<li class="page-item '.($page>=$pages?'disabled':'').'">
                <a class="page-link" href="?'.http_build_query(array_merge($_GET,['page'=>$next])).'">&raquo;</a>
              </li>';

    $html .= '</ul></nav>';

    return [$limitSql, $html];
}