<?php
// ============================================================================
// Secure role & session handler for Visitor Gate Pass
// Starts session safely and redirects if unauthorized
// ============================================================================

// Start session only if not already started and before any output
if (session_status() === PHP_SESSION_NONE) {
    ob_start();               // begin output buffering (prevents header issues)
    session_start();
}

// Handle automatic logout cleanup if session expired or missing
if (!isset($_SESSION['user_id']) || empty($_SESSION['role'])) {
    $_SESSION = [];
    session_destroy();
    header("Location: /auth/login.php");
    exit();
}

/**
 * Simple helper: ensure the current user's role is allowed to access a page.
 * @param array $allowed_roles
 */
function require_roles(array $allowed_roles) {
    if (!isset($_SESSION['role']) || !in_array($_SESSION['role'], $allowed_roles)) {
        header("Location: /auth/login.php?denied=1");
        exit();
    }
}

/**
 * Helper to check role quickly inside templates
 */
function current_role() {
    return $_SESSION['role'] ?? 'guest';
}
?>
