<?php
// /index.php
require_once __DIR__ . '/config/db.php';
require_once __DIR__ . '/config/bootstrap.php';
echo "Bootstrap loaded successfully!";
exit;


function setting($key, $default = '') {
  global $conn;
  $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key=? LIMIT 1");
  $stmt->bind_param("s", $key);
  $stmt->execute();
  $res = $stmt->get_result()->fetch_assoc();
  return $res ? $res['setting_value'] : $default;
}

$company_name   = setting('company_name', 'Visitor Gate Pass');
$company_slogan = setting('company_slogan', 'Secure and Smart Visitor Management');
$logo           = setting('company_logo', '');     // e.g. uploads/logo/xxx.png
$banner         = setting('ui_banner', '');        // e.g. uploads/ui/xxx.jpg

$logo_src   = $logo   ? 'assets/' . $logo   : 'assets/logo/logo.png';
$banner_src = $banner ? 'assets/' . $banner : 'assets/bg/bg.jpg';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?php echo htmlspecialchars($company_name); ?> - Visitor Gate Pass</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="/assets/bootstrap.min.css" rel="stylesheet">
  <link href="/assets/style.css" rel="stylesheet">
  <link rel="icon" href="/assets/favicon/favicon.ico">
  <style>
    body{background:#f7f9fc;}
    .hero{min-height:100vh;display:grid;grid-template-columns:1.1fr 1fr;}
    .hero-left{padding:48px 8vw;background:linear-gradient(180deg,#eef3ff, #f7f9fc);}
    .brand{display:flex;align-items:center;gap:12px;margin-bottom:24px}
    .brand img{height:44px}
    .kicker{color:#7f8aa3;letter-spacing:.08em;font-weight:700;font-size:.85rem}
    .title{font-weight:800;color:#0b1b4d;line-height:1.1;margin:14px 0 10px}
    .slogan{font-size:1.05rem;color:#5b6785;margin-bottom:22px}
    .cta .btn{padding:.9rem 1.2rem;border-radius:10px}
    .hero-right{position:relative}
    .hero-right .banner{position:absolute;inset:0;background:url('<?php echo htmlspecialchars($banner_src); ?>') center/cover no-repeat}
    @media (max-width: 992px){.hero{grid-template-columns:1fr}.hero-right{min-height:40vh}}
  </style>
</head>
<body>
  <div class="hero">
    <div class="hero-left">
      <div class="brand">
        <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="Logo">
        <strong><?php echo htmlspecialchars($company_name); ?></strong>
      </div>

      <div class="kicker">APPOINTMENT BOOKING & ACCESS MANAGEMENT</div>
      <h1 class="title display-5"><?php echo htmlspecialchars($company_name); ?></h1>
      <p class="slogan"><?php echo htmlspecialchars($company_slogan); ?></p>
      <p class="text-muted mb-4">Welcome, please tap on the button below to check-in a visitor.</p>

      <div class="cta d-flex gap-3">
        <a href="/receptionist/visitors_add.php" class="btn btn-warning fw-semibold">Check In a Visitor</a>
        <a href="/auth/login.php" class="btn btn-outline-primary">Staff Login</a>
      </div>
    </div>

    <div class="hero-right">
      <div class="banner" role="img" aria-label="Company banner"></div>
    </div>
  </div>

  <script src="/assets/bootstrap.bundle.min.js"></script>
</body>
</html>