<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/pagination.php';

if (function_exists('require_roles')) {
  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);
}

/* Pagination setup */
$page  = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$count = $conn->query("SELECT COUNT(*) AS t FROM visitors WHERE status='expected'")
              ->fetch_assoc()['t'];

$sql = "
SELECT v.*, e.name AS host_name, d.name AS department_name
FROM visitors v
LEFT JOIN employees e ON e.id=v.host_id
LEFT JOIN departments d ON d.id=v.department_id
WHERE v.status='expected'
ORDER BY v.checkin_date ASC
LIMIT $limit OFFSET $offset
";

$list = $conn->query($sql);
?>
<h3 class="mb-3">Expected Visitors Report</h3>

<div class="card p-0 mt-3">
<div class="table-responsive">
<table class="table table-hover align-middle mb-0">
<thead class="table-light">
<tr>
  <th>#</th>
  <th>Name</th>
  <th>Phone</th>
  <th>Email</th>
  <th>Host</th>
  <th>Dept</th>
  <th>Expected Time</th>
</tr>
</thead>
<tbody>
<?php $i = $offset + 1; while($r=$list->fetch_assoc()): ?>
<tr>
  <td><?php echo $i++; ?></td>
  <td><?php echo htmlspecialchars($r['name']); ?></td>
  <td><?php echo htmlspecialchars($r['phone']); ?></td>
  <td><?php echo htmlspecialchars($r['email']); ?></td>
  <td><?php echo htmlspecialchars($r['host_name']); ?></td>
  <td><?php echo htmlspecialchars($r['department_name']); ?></td>
  <td><?php echo htmlspecialchars($r['expected_time']); ?></td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>
</div>

<?php echo pagination_links($page, $count, $limit); ?>

<?php include __DIR__ . '/../includes/footer.php'; ?>