<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/pagination.php';

if (function_exists('require_roles')) {
  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);
}

$page  = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$total = $conn->query("SELECT COUNT(*) AS t FROM induction")->fetch_assoc()['t'];

$sql = "
SELECT i.*
FROM induction i
ORDER BY i.induction_date DESC, i.id DESC
LIMIT $limit OFFSET $offset
";
$res = $conn->query($sql);
?>
<h3 class="mb-3">Induction Report</h3>

<div class="card p-0">
<div class="table-responsive">
<table class="table table-hover mb-0 align-middle">
<thead class="table-light">
<tr>
  <th>#</th>
  <th>Name</th>
  <th>Company</th>
  <th>Phone</th>
  <th>Email</th>
  <th>Status</th>
  <th>Induction Date</th>
</tr>
</thead>
<tbody>
<?php $i=$offset+1; while($row=$res->fetch_assoc()): ?>
<tr>
  <td><?php echo $i++; ?></td>
  <td><?php echo htmlspecialchars($row['name']); ?></td>
  <td><?php echo htmlspecialchars($row['company']); ?></td>
  <td><?php echo htmlspecialchars($row['phone']); ?></td>
  <td><?php echo htmlspecialchars($row['email']); ?></td>
  <td><?php echo htmlspecialchars($row['status']); ?></td>
  <td><?php echo htmlspecialchars($row['induction_date']); ?></td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>
</div>

<?php echo pagination_links($page, $total, $limit); ?>

<?php include __DIR__ . '/../includes/footer.php'; ?>