<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/pagination.php';

if (function_exists('require_roles')) {
  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);
}

$page  = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = 20;
$offset = ($page - 1) * $limit;

$total = $conn->query("SELECT COUNT(*) AS t FROM visitors WHERE status='returning'")->fetch_assoc()['t'];

$sql = "
SELECT v.*, e.name AS host_name, d.name AS department_name
FROM visitors v
LEFT JOIN employees e ON e.id=v.host_id
LEFT JOIN departments d ON d.id=v.department_id
WHERE v.status='returning'
ORDER BY v.id DESC
LIMIT $limit OFFSET $offset
";
$res = $conn->query($sql);
?>

<h3 class="mb-3">Returning Visitor Report</h3>

<div class="card p-0">
<div class="table-responsive">
<table class="table table-hover mb-0 align-middle">
<thead class="table-light">
<tr>
  <th>#</th>
  <th>Name</th>
  <th>Phone</th>
  <th>Email</th>
  <th>Host</th>
  <th>Dept</th>
  <th>Last Check-in</th>
</tr>
</thead>
<tbody>
<?php $i=$offset+1; while($row=$res->fetch_assoc()): ?>
<tr>
  <td><?php echo $i++; ?></td>
  <td><?php echo htmlspecialchars($row['name']); ?></td>
  <td><?php echo htmlspecialchars($row['phone']); ?></td>
  <td><?php echo htmlspecialchars($row['email']); ?></td>
  <td><?php echo htmlspecialchars($row['host_name']); ?></td>
  <td><?php echo htmlspecialchars($row['department_name']); ?></td>
  <td><?php echo $row['checkin_date'].' '.$row['checkin_time']; ?></td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>
</div>

<?php echo pagination_links($page, $total, $limit); ?>

<?php include __DIR__ . '/../includes/footer.php'; ?>