<?php
// ============================================================
// Visitor Gate Pass - Tag-based Checkout (FINAL, FIXED VERSION)
// ============================================================
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/checkout_error_log.txt');
error_reporting(E_ALL);

while (ob_get_level()) ob_end_clean();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/mailer.php';
require_once __DIR__ . '/../includes/functions.php';

// 1️⃣ Validate tag number
$tag = trim($_POST['tag_number'] ?? '');
if ($tag === '') {
    echo json_encode(['ok' => false, 'error' => 'Tag number is required.']);
    exit;
}

// 2️⃣ ALWAYS fetch the most recent visitor with this tag
$stmt = $conn->prepare("
    SELECT * FROM visitors 
    WHERE tag_number = ? 
    ORDER BY id DESC 
    LIMIT 1
");
$stmt->bind_param("s", $tag);
$stmt->execute();
$visitor = $stmt->get_result()->fetch_assoc();

if (!$visitor) {
    echo json_encode(['ok' => false, 'error' => 'No visitor found for that tag number.']);
    exit;
}

// 3️⃣ Validate status
$status = strtolower(trim($visitor['status'] ?? ''));
if ($status !== 'checked_in') {
    echo json_encode([
        'ok' => false,
        'error' => "Visitor is not currently checked in. (Found status: {$status})"
    ]);
    exit;
}

// 4️⃣ Perform checkout
$upd = $conn->prepare("
    UPDATE visitors 
    SET status='checked_out', checkout_time=NOW() 
    WHERE id = ?
");
$upd->bind_param("i", $visitor['id']);
$upd->execute();

// 5️⃣ Update induction logs
$upd2 = $conn->prepare("
    UPDATE induction 
    SET status='checked_out' 
    WHERE phone=? OR email=?
");
$upd2->bind_param("ss", $visitor['phone'], $visitor['email']);
$upd2->execute();

// 6️⃣ Notify host + extra emails
$name     = $visitor['name'];
$phone    = $visitor['phone'];
$email    = $visitor['email'];
$host_id  = (int)$visitor['host_id'];
$checkin  = "{$visitor['checkin_date']} {$visitor['checkin_time']}";
$checkout = date('Y-m-d H:i:s');

$to = [];

$hostInfo = get_employee_email($host_id);
if (!empty($hostInfo['email'])) $to[] = $hostInfo['email'];

$extra = setting_val('notify_checkout_emails', '');
$extra_list = split_emails($extra);
$to = array_unique(array_merge($to, $extra_list));

if (!empty($to)) {
    $subject = "Visitor Checkout Notification";
    $body =
"Visitor {$name} has checked out.

Phone: {$phone}
Email: {$email}
Check-In: {$checkin}
Check-Out: {$checkout}
Tag Number: {$tag}

-- Visitor Gate Pass";
    sendMail($to, $subject, $body);
}

// 7️⃣ Success output
echo json_encode([
    'ok' => true,
    'message' => "{$name} checked out successfully using tag {$tag}."
]);
exit;