<?php include __DIR__ . '/../includes/header.php'; echo "\n<?php\nif (function_exists('require_roles')) {\n  require_roles(['admin_officer','receptionist','system_admin','it_officer','hse_officer','cso','pa']);\n}\n?>\n"; require_once __DIR__ . '/../config/db.php';
$deps=$conn->query("SELECT id,name FROM departments ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['form']??'')==='save') {
  $id=(int)($_POST['id']??0); $name=trim($_POST['name']??''); $email=trim($_POST['email']??''); $phone=trim($_POST['phone']??''); $dep=(int)($_POST['department_id']??0);
  if ($name!=='') {
    if ($id>0) { $stmt=$conn->prepare("UPDATE employees SET name=?,email=?,phone=?,department_id=? WHERE id=?"); $stmt->bind_param("sssii",$name,$email,$phone,$dep,$id); $stmt->execute(); $msg="Employee updated."; }
    else { $stmt=$conn->prepare("INSERT INTO employees(name,email,phone,department_id) VALUES(?,?,?,?)"); $stmt->bind_param("sssi",$name,$email,$phone,$dep); $stmt->execute(); $msg="Employee added."; }
  }
}
if (($_GET['action']??'')==='delete' && isset($_GET['id'])) { $conn->query("DELETE FROM employees WHERE id=".(int)$_GET['id']); $msg="Employee deleted."; }
$res=$conn->query("SELECT e.id,e.name,e.email,e.phone,d.name AS department FROM employees e LEFT JOIN departments d ON d.id=e.department_id ORDER BY e.name ASC");
?>
<h3 class="mb-3">Employees (Host Management)</h3>
<?php if(!empty($msg)) echo "<div class='alert alert-success'>$msg</div>"; ?>
<div class="row g-3">
  <div class="col-md-5">
    <div class="card p-3"><h5 class="mb-3">Add / Edit Employee</h5>
      <form method="POST">
        <input type="hidden" name="form" value="save"><input type="hidden" name="id" id="emp_id">
        <div class="mb-2"><label class="form-label">Full Name</label><input class="form-control" name="name" id="emp_name" required></div>
        <div class="mb-2"><label class="form-label">Email</label><input type="email" class="form-control" name="email" id="emp_email"></div>
        <div class="mb-2"><label class="form-label">Phone</label><input class="form-control" name="phone" id="emp_phone"></div>
        <div class="mb-3"><label class="form-label">Department</label>
          <select class="form-select" name="department_id" id="emp_dep">
            <option value="0">-- None --</option>
            <?php foreach($deps as $d): ?><option value="<?php echo $d['id']; ?>"><?php echo htmlspecialchars($d['name']); ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="d-flex gap-2"><button class="btn btn-primary">Save</button><button type="button" class="btn btn-secondary" onclick="clearEmp()">Clear</button></div>
      </form>
    </div>
  </div>
  <div class="col-md-7">
    <div class="card p-0">
      <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
          <thead class="table-light"><tr><th>#</th><th>Name</th><th>Email</th><th>Phone</th><th>Department</th><th>Action</th></tr></thead>
          <tbody>
            <?php $i=1; while($r=$res->fetch_assoc()): ?>
            <tr>
              <td><?php echo $i++; ?></td>
              <td><?php echo htmlspecialchars($r['name']); ?></td>
              <td><?php echo htmlspecialchars($r['email']); ?></td>
              <td><?php echo htmlspecialchars($r['phone']); ?></td>
              <td><?php echo htmlspecialchars($r['department'] ?? '-'); ?></td>
              <td class="text-nowrap">
                <button class="btn btn-sm btn-outline-primary" onclick="editEmp(<?php echo $r['id']; ?>,'<?php echo htmlspecialchars($r['name'],ENT_QUOTES); ?>','<?php echo htmlspecialchars($r['email'],ENT_QUOTES); ?>','<?php echo htmlspecialchars($r['phone'],ENT_QUOTES); ?>')">Edit</button>
                <a class="btn btn-sm btn-outline-danger" href="?action=delete&id=<?php echo $r['id']; ?>" onclick="return confirm('Delete this employee?')">Delete</a>
              </td>
            </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<script>
function editEmp(id,name,email,phone){
  document.getElementById('emp_id').value=id;
  document.getElementById('emp_name').value=name;
  document.getElementById('emp_email').value=email;
  document.getElementById('emp_phone').value=phone;
  window.scrollTo({top:0, behavior:'smooth'});
}
function clearEmp(){
  document.getElementById('emp_id').value='';
  document.getElementById('emp_name').value='';
  document.getElementById('emp_email').value='';
  document.getElementById('emp_phone').value='';
}
</script>
<?php include __DIR__ . '/../includes/footer.php'; ?>
