<?php
include __DIR__ . '/../includes/header.php';

if (function_exists('require_roles')) {
    require_roles([
        'admin_officer','receptionist','system_admin',
        'it_officer','hse_officer','cso','pa'
    ]);
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/mailer.php';
require_once __DIR__ . '/../includes/notify.php';

$msg = "";
$err = "";

/* ----------------------------------------------------
   FETCH HOSTS & DEPARTMENTS
---------------------------------------------------- */
$deps = $conn->query("SELECT id, name FROM departments ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$hosts = $conn->query("SELECT id, name FROM employees ORDER BY name")->fetch_all(MYSQLI_ASSOC);

/* ----------------------------------------------------
   HANDLE RETURNING VISITOR CHECK-IN
---------------------------------------------------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['returning'])) {

    $phone   = trim($_POST['phone'] ?? '');
    $purpose = trim($_POST['purpose'] ?? '');
    $host_id = intval($_POST['host_id'] ?? 0);
    $dept_id = intval($_POST['department_id'] ?? 0);

    if ($phone === "") {
        $err = "Phone number is required.";
    } else {

        // Fetch existing visitor by phone
        $stmt = $conn->prepare("
            SELECT * FROM visitors 
            WHERE phone=? 
            ORDER BY id DESC 
            LIMIT 1
        ");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $visitor = $stmt->get_result()->fetch_assoc();

        if (!$visitor) {
            $err = "No previous visitor record found for this phone number.";
        } else {

            $name  = $visitor['name'];
            $email = $visitor['email'];

            // Insert returning check-in
            $sql = "INSERT INTO visitors
                    (name, phone, email, company, gender, address, purpose, 
                     host_id, department_id, checkin_date, checkin_time, status)
                    VALUES (?,?,?,?,?,?,?,?,?, CURDATE(), CURTIME(), 'returning')";

            $stmt2 = $conn->prepare($sql);
            $stmt2->bind_param(
                "sssssssii",
                $visitor['name'],
                $visitor['phone'],
                $visitor['email'],
                $visitor['company'],
                $visitor['gender'],
                $visitor['address'],
                $purpose,
                $host_id,
                $dept_id
            );

            if ($stmt2->execute()) {

                $msg = "Returning visitor has been checked in.";

                /* ----------------------------------------------------
                   SEND NOTIFICATION (simple)
                ---------------------------------------------------- */
                notify_returning_visitor($name, $phone);

                /* ----------------------------------------------------
                   SEND ADVANCED RETURNING VISITOR NOTIFICATION
                ---------------------------------------------------- */
                $hostRow   = get_employee_email($host_id);
                $host_name = $hostRow['name'] ?? "Unknown Host";

                $full_msg =
"Returning visitor has been checked in.

Name: {$name}
Phone: {$phone}
Email: {$email}
Purpose: {$purpose}
Host: {$host_name}
Department ID: {$dept_id}

-- Visitor Gate Pass System";

                $extra = setting_val('notify_returning_emails', '');
                $extra_list = split_emails($extra);

                if (!empty($extra_list)) {
                    sendMail($extra_list, "Returning Visitor Notification", $full_msg);
                }

            } else {
                $err = "Failed to register returning visitor.";
            }
        }
    }
}
?>

<h3 class="mb-4">Returning Visitor</h3>

<?php if ($msg): ?>
    <div class="alert alert-success"><?php echo $msg; ?></div>
<?php endif; ?>

<?php if ($err): ?>
    <div class="alert alert-danger"><?php echo $err; ?></div>
<?php endif; ?>

<form method="POST" class="bg-white p-4 rounded shadow-sm">

    <div class="row g-3">

        <div class="col-md-6">
            <label class="form-label">Phone Number</label>
            <input type="text" name="phone" class="form-control" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Purpose of Visit</label>
            <input type="text" name="purpose" class="form-control" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Host</label>
            <select name="host_id" class="form-select" required>
                <option value="">-- Select Host --</option>
                <?php foreach ($hosts as $h): ?>
                    <option value="<?php echo $h['id']; ?>">
                        <?php echo htmlspecialchars($h['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label">Department</label>
            <select name="department_id" class="form-select" required>
                <option value="">-- Select Department --</option>
                <?php foreach ($deps as $d): ?>
                    <option value="<?php echo $d['id']; ?>">
                        <?php echo htmlspecialchars($d['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

    </div>

    <div class="text-end mt-4">
        <button name="returning" class="btn btn-primary px-4">
            Check-In Returning Visitor
        </button>
    </div>

</form>

<?php include __DIR__ . '/../includes/footer.php'; ?>