<?php
// /shared/visitor_recheckin.php
header('Content-Type: application/json');

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/mailer.php';

// Basic validation
$id            = (int)($_POST['id'] ?? 0);
$host_id       = (int)($_POST['host_id'] ?? 0);
$department_id = (int)($_POST['department_id'] ?? 0);
$purpose       = trim($_POST['purpose'] ?? '');
$items         = trim($_POST['items_declared'] ?? '');
$tag           = trim($_POST['tag_number'] ?? '');

if ($id <= 0)                    { echo json_encode(['ok'=>false,'error'=>'Invalid visitor id']); exit; }
if ($host_id <= 0)               { echo json_encode(['ok'=>false,'error'=>'Please select a host']); exit; }
if ($department_id <= 0)         { echo json_encode(['ok'=>false,'error'=>'Please select a department']); exit; }
if ($purpose === '')             { echo json_encode(['ok'=>false,'error'=>'Purpose is required']); exit; }

// Load the original visitor record for immutable fields
$stmt = $conn->prepare("SELECT name,phone,email,company,gender,address FROM visitors WHERE id=? LIMIT 1");
$stmt->bind_param("i",$id);
$stmt->execute();
$base = $stmt->get_result()->fetch_assoc();
if (!$base) { echo json_encode(['ok'=>false,'error'=>'Original visitor not found']); exit; }

// Insert new check-in row
$ins = $conn->prepare("
  INSERT INTO visitors
  (name, phone, email, company, gender, address,
   purpose, items_declared, tag_number,
   host_id, department_id, checkin_date, checkin_time, status)
  VALUES (?,?,?,?,?,?,?,?,?,?,?, CURDATE(), CURTIME(), 'checked_in')
");
$ins->bind_param(
  "ssssssssiii",
  $base['name'], $base['phone'], $base['email'], $base['company'], $base['gender'], $base['address'],
  $purpose, $items, $tag,
  $host_id, $department_id
);
$ins->execute();

// Notify selected host
$host = get_employee_email($host_id); // ['email','name']
if (!empty($host['email'])) {
  $subject = "Returning Visitor Notification";
  $text =
"Hello {$host['name']},

Visitor {$base['name']} has returned and is now checked in.

Purpose: {$purpose}
Phone: {$base['phone']}
Date: ".date('Y-m-d H:i')."

-- Visitor Gate Pass";
  sendMail($host['email'], $subject, $text);
}

echo json_encode(['ok'=>true,'message'=>"Visitor {$base['name']} re-checked in successfully."]);
