<?php
include __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/mailer.php';
require_once __DIR__ . '/../includes/notify.php';

if (function_exists('require_roles')) {
    require_roles([
        'admin_officer','receptionist','system_admin',
        'it_officer','hse_officer','cso','pa'
    ]);
}

/* PREFILL */
$prefill_name  = $_GET['prefill_name']  ?? '';
$prefill_phone = $_GET['prefill_phone'] ?? '';
$prefill_email = $_GET['prefill_email'] ?? '';

/* FETCH HOSTS & DEPARTMENTS */
$deps  = $conn->query("SELECT id, name FROM departments ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$hosts = $conn->query("SELECT id, name FROM employees ORDER BY name")->fetch_all(MYSQLI_ASSOC);

$msg = "";
$err = "";

/* PROCESS CHECK-IN */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['checkin'])) {

    $checkin_date = $_POST['checkin_date'] ?: date('Y-m-d');
    $checkin_time = $_POST['checkin_time'] ?: date('H:i');

    $name     = trim($_POST['name']);
    $company  = trim($_POST['company']);
    $phone    = trim($_POST['phone']);
    $email    = trim($_POST['email']);
    $gender   = trim($_POST['gender']);
    $address  = trim($_POST['address']);

    $host_id       = intval($_POST['host_id']);
    $department_id = intval($_POST['department_id']);
    $purpose       = trim($_POST['purpose']);
    $items_declared = trim($_POST['items']);
    $tag_number     = trim($_POST['tag_number']);

    if ($name === '' || $phone === '') {
        $err = "Full Name and Phone Number are required.";
    } else {

        /* TAG NUMBER VALIDATION */
        if (!empty($tag_number)) {
            $checkTag = $conn->prepare("
                SELECT id FROM visitors 
                WHERE tag_number = ? 
                AND status IN ('checked_in','returning')
                LIMIT 1
            ");
            $checkTag->bind_param("s", $tag_number);
            $checkTag->execute();
            $inUse = $checkTag->get_result()->fetch_assoc();

            if ($inUse) {
                $err = "Tag number '{$tag_number}' is already assigned to a visitor who has not checked out.";
            }
        }

        if ($err === "") {

            /* UPLOADS */
            $photo = "";
            $attachment = "";
            $uploadDir = __DIR__ . '/../assets/uploads/visitors/';
            $publicDir = "assets/uploads/visitors/";

            if (!is_dir($uploadDir)) @mkdir($uploadDir, 0755, true);

            if (!empty($_FILES['photo']['name'])) {
                $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
                $file = "photo_" . time() . "." . $ext;
                if (move_uploaded_file($_FILES['photo']['tmp_name'], $uploadDir . $file)) {
                    $photo = $publicDir . $file;
                }
            }

            if (!empty($_FILES['attachment']['name'])) {
                $ext = pathinfo($_FILES['attachment']['name'], PATHINFO_EXTENSION);
                $file = "file_" . time() . "." . $ext;
                if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadDir . $file)) {
                    $attachment = $publicDir . $file;
                }
            }

            /* INSERT */
            $sql = "INSERT INTO visitors 
                (name, phone, email, company, gender, address, photo, attachment,
                 purpose, items_declared, tag_number, host_id, department_id,
                 checkin_date, checkin_time, status)
                VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, 'checked_in')";

            $stmt = $conn->prepare($sql);
            $stmt->bind_param(
                "sssssssssssisss",
                $name, $phone, $email, $company, $gender, $address,
                $photo, $attachment, $purpose, $items_declared,
                $tag_number, $host_id, $department_id,
                $checkin_date, $checkin_time
            );

            if ($stmt->execute()) {

                $msg = "Visitor checked in successfully.";
                notify_checkin($name, $department_id, $purpose, $host_id);

                $upd = $conn->prepare("
                    UPDATE induction SET status='inducted', inducted_time=NOW() 
                    WHERE phone=? OR email=?
                ");
                $upd->bind_param("ss", $phone, $email);
                $upd->execute();

                if (!empty($_GET['prefill_phone']) || !empty($_GET['prefill_email'])) {
                    $_SESSION['flash_success'] =
                        "Visitor {$name} has been checked in and marked as inducted.";
                    header("Location: /receptionist/induction_register.php");
                    exit;
                }

            } else {
                $err = "Failed to check-in visitor. Please try again.";
            }
        }
    }
}
?>

<h3 class="mb-4">Visitor Check-In</h3>

<?php if ($msg): ?><div class="alert alert-success"><?php echo $msg; ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-danger"><?php echo $err; ?></div><?php endif; ?>

<form method="POST" enctype="multipart/form-data" class="bg-white shadow-sm p-4 rounded-3 border-0">

    <h5 class="text-primary mb-3">Section 1 — Check-In Details</h5>

    <div class="row g-3">
        <div class="col-md-6">
            <label class="form-label">Check-In Date</label>
            <input type="date" name="checkin_date" value="<?php echo date('Y-m-d'); ?>" class="form-control">
        </div>

        <div class="col-md-6">
            <label class="form-label">Check-In Time</label>
            <input type="time" name="checkin_time" value="<?php echo date('H:i'); ?>" class="form-control">
        </div>
    </div>

    <hr class="my-4">

    <h5 class="text-primary mb-3">Visitor Information</h5>

    <div class="row g-3">
        <div class="col-md-6">
            <label class="form-label">Full Names</label>
            <input type="text" name="name" class="form-control"
                   value="<?php echo htmlspecialchars($prefill_name); ?>" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Company</label>
            <input type="text" name="company" class="form-control">
        </div>

        <div class="col-md-6">
            <label class="form-label">Phone Number</label>
            <input type="text" name="phone" class="form-control"
                   value="<?php echo htmlspecialchars($prefill_phone); ?>" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control"
                   value="<?php echo htmlspecialchars($prefill_email); ?>">
        </div>

        <div class="col-md-6">
            <label class="form-label">Gender</label>
            <select name="gender" class="form-select">
                <option value="">-- Select Gender --</option>
                <option>Male</option>
                <option>Female</option>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label">Address</label>
            <input type="text" name="address" class="form-control">
        </div>

        <div class="col-md-6">
            <label class="form-label">Camera / Photo</label>
            <input type="file" name="photo" accept="image/*" class="form-control">
        </div>

        <div class="col-md-6">
            <label class="form-label">Attachments</label>
            <input type="file" name="attachment" class="form-control">
        </div>
    </div>

    <hr class="my-4">

    <h5 class="text-primary mb-3">Host Information</h5>

    <div class="row g-3">
        <div class="col-md-6">
            <label class="form-label">Select Host</label>
            <select name="host_id" class="form-select" required>
                <option value="">-- Select Host --</option>
                <?php foreach ($hosts as $h): ?>
                    <option value="<?php echo $h['id']; ?>">
                        <?php echo htmlspecialchars($h['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label">Department</label>
            <select name="department_id" class="form-select" required>
                <option value="">-- Select Department --</option>
                <?php foreach ($deps as $d): ?>
                    <option value="<?php echo $d['id']; ?>">
                        <?php echo htmlspecialchars($d['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-12">
            <label class="form-label">Purpose of Visit</label>
            <textarea name="purpose" class="form-control" rows="2" required></textarea>
        </div>
    </div>

    <hr class="my-4">

    <h5 class="text-primary mb-3">Security Section</h5>

    <div class="row g-3">

        <div class="col-md-6">
            <label class="form-label">Items Declared</label>
            <input type="text" name="items" class="form-control">
        </div>

        <div class="col-md-6">
            <label class="form-label">Visitor Tag Number</label>
            <input type="text" name="tag_number" class="form-control" placeholder="Enter tag number">
        </div>
    </div>

    <div class="mt-4 text-end">
        <button type="submit" name="checkin" class="btn btn-success px-4">
            Submit Check-In
        </button>
    </div>

</form>

<?php include __DIR__ . '/../includes/footer.php'; ?>