<?php
include __DIR__ . '/../includes/header.php';

if (function_exists('require_roles')) {
    require_roles(['admin_officer','receptionist']);
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/mailer.php';
require_once __DIR__ . '/../includes/notify.php';

$msg = '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $phone = trim($_POST['phone'] ?? '');
    $id    = (int) ($_POST['id'] ?? 0);

    // Helper: fetch visitor before updating, so we can email with their name
    $visitor = null;

    if ($id > 0) {
        $stmt = $conn->prepare(
            "SELECT id, name, phone 
             FROM visitors 
             WHERE id = ? 
               AND status IN ('checked_in','returning') 
             LIMIT 1"
        );
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $visitor = $stmt->get_result()->fetch_assoc();

        if ($visitor) {
            $stmt2 = $conn->prepare(
                "UPDATE visitors 
                 SET checkout_time = NOW(), status = 'checked_out' 
                 WHERE id = ?"
            );
            $stmt2->bind_param("i", $id);
            $stmt2->execute();

            $msg = "Visitor checked out.";

            // 🔔 notify checkout
            $checkout_time = date('Y-m-d H:i:s');
            notify_checkout($visitor['name'], $checkout_time);
        } else {
            $err = "No active visit found for the provided ID.";
        }

    } elseif ($phone !== '') {

        $stmt = $conn->prepare(
            "SELECT id, name, phone 
             FROM visitors 
             WHERE phone = ? 
               AND status IN ('checked_in','returning') 
             ORDER BY checkin_time DESC 
             LIMIT 1"
        );
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $visitor = $stmt->get_result()->fetch_assoc();

        if ($visitor) {
            $stmt2 = $conn->prepare(
                "UPDATE visitors 
                 SET checkout_time = NOW(), status = 'checked_out' 
                 WHERE id = ?"
            );
            $stmt2->bind_param("i", $visitor['id']);
            $stmt2->execute();

            $msg = "Visitor checked out.";

            // 🔔 notify checkout
            $checkout_time = date('Y-m-d H:i:s');
            notify_checkout($visitor['name'], $checkout_time);
        } else {
            $msg = "No active visit found.";
        }

    } else {
        $err = "Provide an ID or phone.";
    }
}

$list = $conn->query(
    "SELECT id, name, phone, checkin_time 
     FROM visitors 
     WHERE status IN ('checked_in','returning') 
     ORDER BY checkin_time DESC"
);
?>

<h3 class="mb-3">Check-out Visitor</h3>

<?php if ($msg): ?>
    <div class="alert alert-success"><?php echo $msg; ?></div>
<?php endif; ?>

<?php if ($err): ?>
    <div class="alert alert-danger"><?php echo $err; ?></div>
<?php endif; ?>

<div class="card p-3 mb-3">
<form method="POST" class="row g-3">
    <div class="col-md-4">
        <label class="form-label">Visitor ID</label>
        <input class="form-control" name="id">
    </div>

    <div class="col-md-4">
        <label class="form-label">Phone (alt)</label>
        <input class="form-control" name="phone">
    </div>

    <div class="col-md-4 d-flex align-items-end">
        <button class="btn btn-primary w-100">Check-out</button>
    </div>
</form>
</div>

<div class="card p-0">
<div class="table-responsive">
<table class="table table-hover align-middle mb-0">
    <thead class="table-light">
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Phone</th>
            <th>Checked-in</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($r = $list->fetch_assoc()): ?>
            <tr>
                <td><?php echo $r['id']; ?></td>
                <td><?php echo htmlspecialchars($r['name']); ?></td>
                <td><?php echo htmlspecialchars($r['phone']); ?></td>
                <td><?php echo $r['checkin_time']; ?></td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>
</div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>