<?php
include __DIR__ . '/../includes/header.php';

if (function_exists('require_roles')) {
    require_roles([
        'admin_officer','receptionist','system_admin',
        'it_officer','hse_officer','cso','pa'
    ]);
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/mailer.php';
require_once __DIR__ . '/../includes/notify.php';

$msg = "";
$err = "";

/* ----------------------------------------------------
   FETCH HOSTS & DEPARTMENTS
---------------------------------------------------- */
$deps  = $conn->query("SELECT id, name FROM departments ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$hosts = $conn->query("SELECT id, name FROM employees ORDER BY name")->fetch_all(MYSQLI_ASSOC);

/* ----------------------------------------------------
   HANDLE EXPECTED VISITOR SUBMISSION
---------------------------------------------------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['expected'])) {

    $name     = trim($_POST['name'] ?? '');
    $phone    = trim($_POST['phone'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $company  = trim($_POST['company'] ?? '');
    $gender   = trim($_POST['gender'] ?? '');
    $purpose  = trim($_POST['purpose'] ?? '');
    $host_id  = intval($_POST['host_id'] ?? 0);
    $dept_id  = intval($_POST['department_id'] ?? 0);
    $exp_date = trim($_POST['visit_date'] ?? date('Y-m-d'));

    if ($name === "" || $phone === "") {
        $err = "Name and phone number are required.";
    } else {

        // Save as expected visitor
        $sql = "INSERT INTO visitors
                (name, phone, email, company, gender, purpose, host_id, department_id,
                 checkin_date, status)
                VALUES (?,?,?,?,?,?,?,?,?, 'expected')";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param(
            "ssssssiis",
            $name,
            $phone,
            $email,
            $company,
            $gender,
            $purpose,
            $host_id,
            $dept_id,
            $exp_date   // stored in checkin_date
        );

        if ($stmt->execute()) {

            $msg = "Expected visitor saved successfully.";

            // Fetch host name for email
            $hostInfo = get_employee_email($host_id);
            $host_name = $hostInfo['name'] ?? "Unknown Host";

            // Trigger notification
            notify_expected_visitor($name, $exp_date, $host_name);
        }
    }
}
?>

<h3 class="mb-4">Expected Visitors</h3>

<?php if ($msg): ?>
<div class="alert alert-success"><?php echo $msg; ?></div>
<?php endif; ?>

<?php if ($err): ?>
<div class="alert alert-danger"><?php echo $err; ?></div>
<?php endif; ?>

<form method="POST" class="bg-white p-4 rounded shadow-sm">

  <div class="row g-3">

    <div class="col-md-6">
      <label class="form-label">Visitor Name</label>
      <input type="text" name="name" class="form-control" required>
    </div>

    <div class="col-md-6">
      <label class="form-label">Company</label>
      <input type="text" name="company" class="form-control">
    </div>

    <div class="col-md-6">
      <label class="form-label">Phone</label>
      <input type="text" name="phone" class="form-control" required>
    </div>

    <div class="col-md-6">
      <label class="form-label">Email</label>
      <input type="email" name="email" class="form-control">
    </div>

    <div class="col-md-6">
      <label class="form-label">Gender</label>
      <select name="gender" class="form-select" required>
        <option value="">-- Select Gender --</option>
        <option>Male</option>
        <option>Female</option>
      </select>
    </div>

    <div class="col-md-6">
      <label class="form-label">Host</label>
      <select name="host_id" class="form-select" required>
        <option value="">-- Select Host --</option>
        <?php foreach ($hosts as $h): ?>
        <option value="<?php echo $h['id']; ?>">
          <?php echo htmlspecialchars($h['name']); ?>
        </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-md-6">
      <label class="form-label">Department</label>
      <select name="department_id" class="form-select" required>
        <option value="">-- Select Department --</option>
        <?php foreach ($deps as $d): ?>
        <option value="<?php echo $d['id']; ?>">
           <?php echo htmlspecialchars($d['name']); ?>
        </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-12">
      <label class="form-label">Purpose of Visit</label>
      <textarea name="purpose" class="form-control" rows="2" required></textarea>
    </div>

    <div class="col-md-6">
      <label class="form-label">Expected Date</label>
      <input type="date" name="visit_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
    </div>

  </div>

  <div class="text-end mt-4">
    <button name="expected" class="btn btn-primary px-4">Register Expected Visitor</button>
  </div>

</form>

<?php include __DIR__ . '/../includes/footer.php'; ?>